/**
 * \file: InputSourceChannel.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: android auto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2014 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

// to use std::to_string
#include <string>
#include <aauto/AditInputSource.h>
#include "InputSourceChannel.h"
#include "DemoFactory.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto
{

InputSourceChannel::InputSourceChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId,
                                       t_ilm_layer inLayerID, t_ilm_surface inSurfaceID,
                                       IDynamicConfiguration& inConfig) :
    receiver(inReceiver), sessionId(inSessionId), layerID(inLayerID), surfaceID(inSurfaceID), mConfig(&inConfig)
{
}

InputSourceChannel::~InputSourceChannel()
{
    input = nullptr;
}

void InputSourceChannel::shutdown()
{
    LOG_INFO((demo, "input source channel shut down"));
    if (input != nullptr) {
        input->shutdown();
    }
}

bool InputSourceChannel::Initialize()
{
    bool ret = false;

    LOGD_DEBUG((demo, "new WaylandInputSource"));

    /* This pointer is deleted at shared_ptr in impl */
    auto creator = DemoFactory::instance().getCreator
            <AditInputSource, InputSourceCreatorFn>(mConfig->GetItem("adit-input-source", ""));
    if (creator != nullptr)
    {
        input = creator(sessionId, receiver->messageRouter());
    }
    else
    {
        LOG_ERROR((demo, "failed to get creator object"));
        ret = false;
    }

    if (input == nullptr)
    {
        LOG_ERROR((demo, "failed to get output of creator"));
        ret = false;
    }
    else
    {
        /* necessary for registerTouchScreen() */
        int width = 0;
        int height = 0;

        /* get list of InputSource configuration values */
        std::list<std::string> input_source = mConfig->GetItems("input-source");
        for (auto node : input_source)
        {
            std::string key;
            std::string value;
            /* get key and respective value from node entry */
            mConfig->GetNodeItem(node, key, value);

            if (0 == key.compare("touch-width")) {
                width = stoi(value);
            }
            if (0 == key.compare("touch-height")) {
                height = stoi(value);
            }

            /* set configuration for InputSource Endpoint */
            input->setConfigItem(key, value);
        }

        /* Configure values which are not part of InputSource configuration node */
        input->setConfigItem("wl-touch-layer-id", std::to_string(layerID));
        input->setConfigItem("wl-touch-surface-id", std::to_string(surfaceID));

        input->registerCallbacks(this);
        // Initialize for ADIT InputSource
        if(true == (ret = input->init()))
        {
            // Register touchScreen
            LOGD_DEBUG((demo, "Register TouchScreen"));
            input->registerTouchScreen(width, height, CAPACITIVE);

            // Register service for InputSource
            LOGD_DEBUG((demo, "Register Service"));
            // The argument of API is done const_cast because GalReceiver requires non const pointer.
            ret = receiver->registerService(const_cast<AditInputSource *> (input.get()));
        }
    }

    return ret;
}

void InputSourceChannel::onInputFeedback(const InputFeedback& inFeedback)
{
    LOGD_DEBUG((demo, "Got input feedback"));
}

void InputSourceChannel::notifyErrorCallback(aautoErrorCodes inErrorCode)
{
    LOG_ERROR((demo, "InputSourceChannel::notifyErrorCallback: %d", inErrorCode));
}


} } // namespace adit { namespace aauto
